package com.ejie.ab04b.model;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

import java.util.Arrays;
import java.util.Date;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * Ab0465s00 generated by UDA, 15-Feb-2017 09:14:46.
 * 
 * @author UDA
 */

public class DocumentoAperturas implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Long idDocumento065;
	private TramiteAperturas tramiteAperturas;
	private Integer origen065;
	private Date fechaDoc065;
	private String rutaPif065;
	private String nombreDoc065;
	private String oidDokusi065;
	private TipoDocumento tipoDocumento;
	private String formatoAport065;
	private TareaAperturas tareaAperturasContinuar;
	private DatosEnvioPostal datosEnvioPostal;

	private boolean migrado = false;

	// datos binarios del fichero
	private byte[] datosFichero;

	// formato para descargar de dokusi
	private String dokusiFormat;

	// para los documentos temporales
	private Long idapetemp065;

	private String territorio;

	/**
	 * Method 'Ab0465s00'.
	 */
	public DocumentoAperturas() {
	}

	/**
	 * Method 'Ab0465s00'.
	 * 
	 * idDocumento065 Long
	 * 
	 * @param idDocumento065
	 *            the id documento 065
	 */
	public DocumentoAperturas(Long idDocumento065) {
		this.idDocumento065 = idDocumento065;
	}

	/**
	 * Method 'Ab0465s00'.
	 * 
	 * idDocumento065 Long tramiteAperturas TramiteAperturas origen065 Integer
	 * fechaDoc065 Date rutaPif065 String nombreDoc065 String oidDokusi065
	 * String tipoDocumento TipoDocumento formatoAport065 String
	 * 
	 * @param idDocumento065
	 *            the id documento 065
	 * @param tramiteAperturas
	 *            the tramite aperturas
	 * @param origen065
	 *            the origen 065
	 * @param fechaDoc065
	 *            the fecha doc 065
	 * @param rutaPif065
	 *            the ruta pif 065
	 * @param nombreDoc065
	 *            the nombre doc 065
	 * @param oidDokusi065
	 *            the oid dokusi 065
	 * @param tipoDocumento
	 *            the tipo documento
	 * @param formatoAport065
	 *            the formato aport 065
	 */
	public DocumentoAperturas(Long idDocumento065,
			TramiteAperturas tramiteAperturas, Integer origen065,
			Date fechaDoc065, String rutaPif065, String nombreDoc065,
			String oidDokusi065, TipoDocumento tipoDocumento,
			String formatoAport065) {

		this.idDocumento065 = idDocumento065;
		this.tramiteAperturas = tramiteAperturas;
		this.origen065 = origen065;
		this.fechaDoc065 = fechaDoc065;
		this.rutaPif065 = rutaPif065;
		this.nombreDoc065 = nombreDoc065;
		this.oidDokusi065 = oidDokusi065;
		this.tipoDocumento = tipoDocumento;
		this.formatoAport065 = formatoAport065;
	}

	/**
	 * Instantiates a new documento aperturas.
	 * 
	 * idDocumento065 Long idApertura065 Long rutaPif065 String nombreDoc065
	 * String tipoDocumento TipoDocumento
	 * 
	 * @param idDocumento065
	 *            the id documento 065
	 * @param idApertura065
	 *            the id apertura 065
	 * @param rutaPif065
	 *            the ruta pif 065
	 * @param nombreDoc065
	 *            the nombre doc 065
	 * @param tipoDocumento
	 *            the tipo documento
	 */
	public DocumentoAperturas(Long idDocumento065, Long idApertura065,
			String rutaPif065, String nombreDoc065, TipoDocumento tipoDocumento) {
		this.idDocumento065 = idDocumento065;
		this.idapetemp065 = idApertura065;
		this.rutaPif065 = rutaPif065;
		this.nombreDoc065 = nombreDoc065;
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * Method 'getIdDocumento065'.
	 * 
	 * Long
	 * 
	 * @return the id documento 065
	 */

	public Long getIdDocumento065() {
		return this.idDocumento065;
	}

	/**
	 * Method 'setIdDocumento065'.
	 * 
	 * idDocumento065 Long
	 * 
	 * @param idDocumento065
	 *            the new id documento 065
	 */

	public void setIdDocumento065(Long idDocumento065) {
		this.idDocumento065 = idDocumento065;
	}

	/**
	 * Method 'getTramiteAperturas'.
	 * 
	 * TramiteAperturas
	 * 
	 * @return the tramite aperturas
	 */

	public TramiteAperturas getTramiteAperturas() {
		return this.tramiteAperturas;
	}

	/**
	 * Method 'setTramiteAperturas'.
	 * 
	 * tramiteAperturas TramiteAperturas
	 * 
	 * @param tramiteAperturas
	 *            the new tramite aperturas
	 */

	public void setTramiteAperturas(TramiteAperturas tramiteAperturas) {
		this.tramiteAperturas = tramiteAperturas;
	}

	/**
	 * Method 'getOrigen065'.
	 * 
	 * Integer
	 * 
	 * @return the origen 065
	 */

	public Integer getOrigen065() {
		return this.origen065;
	}

	/**
	 * Method 'setOrigen065'.
	 * 
	 * origen065 Integer
	 * 
	 * @param origen065
	 *            the new origen 065
	 */

	public void setOrigen065(Integer origen065) {
		this.origen065 = origen065;
	}

	/**
	 * Method 'getFechaDoc065'.
	 * 
	 * java.util.Date
	 * 
	 * @return the fecha doc 065
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaDoc065() {
		return this.fechaDoc065;
	}

	/**
	 * Method 'setFechaDoc065'.
	 * 
	 * fechaDoc065 java.util.Date
	 * 
	 * @param fechaDoc065
	 *            the new fecha doc 065
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaDoc065(Date fechaDoc065) {
		this.fechaDoc065 = fechaDoc065;
	}

	/**
	 * Method 'getRutaPif065'.
	 * 
	 * String
	 * 
	 * @return the ruta pif 065
	 */

	public String getRutaPif065() {
		return this.rutaPif065;
	}

	/**
	 * Method 'setRutaPif065'.
	 * 
	 * rutaPif065 String
	 * 
	 * @param rutaPif065
	 *            the new ruta pif 065
	 */

	public void setRutaPif065(String rutaPif065) {
		this.rutaPif065 = rutaPif065;
	}

	/**
	 * Method 'getNombreDoc065'.
	 * 
	 * String
	 * 
	 * @return the nombre doc 065
	 */

	public String getNombreDoc065() {
		return this.nombreDoc065;
	}

	/**
	 * Method 'setNombreDoc065'.
	 * 
	 * nombreDoc065 String
	 * 
	 * @param nombreDoc065
	 *            the new nombre doc 065
	 */

	public void setNombreDoc065(String nombreDoc065) {
		this.nombreDoc065 = nombreDoc065;
	}

	/**
	 * Method 'getOidDokusi065'.
	 * 
	 * String
	 * 
	 * @return the oid dokusi 065
	 */

	public String getOidDokusi065() {
		return this.oidDokusi065;
	}

	/**
	 * Method 'setOidDokusi065'.
	 * 
	 * oidDokusi065 String
	 * 
	 * @param oidDokusi065
	 *            the new oid dokusi 065
	 */

	public void setOidDokusi065(String oidDokusi065) {
		this.oidDokusi065 = oidDokusi065;
	}

	/**
	 * Gets the tipo documento.
	 * 
	 * TipoDocumento
	 * 
	 * @return the tipo documento
	 */
	public TipoDocumento getTipoDocumento() {
		return this.tipoDocumento;
	}

	/**
	 * Sets the tipo documento.
	 * 
	 * tipoDocumento TipoDocumento
	 * 
	 * @param tipoDocumento
	 *            the new tipo documento
	 */
	public void setTipoDocumento(TipoDocumento tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * Gets the formato aport 065.
	 * 
	 * String
	 * 
	 * @return the formato aport 065
	 */
	public String getFormatoAport065() {
		return this.formatoAport065;
	}

	/**
	 * Sets the formato aport 065.
	 * 
	 * formatoAport065 String
	 * 
	 * @param formatoAport065
	 *            the new formato aport 065
	 */
	public void setFormatoAport065(String formatoAport065) {
		this.formatoAport065 = formatoAport065;
	}

	/**
	 * Gets the tarea aperturas continuar.
	 * 
	 * TareaAperturas
	 * 
	 * @return the tarea aperturas continuar
	 */
	public TareaAperturas getTareaAperturasContinuar() {
		return this.tareaAperturasContinuar;
	}

	/**
	 * Sets the tarea aperturas continuar.
	 * 
	 * tareaAperturasContinuar TareaAperturas
	 * 
	 * @param tareaAperturasContinuar
	 *            the new tarea aperturas continuar
	 */
	public void setTareaAperturasContinuar(
			TareaAperturas tareaAperturasContinuar) {
		this.tareaAperturasContinuar = tareaAperturasContinuar;
	}

	/**
	 * Gets the datos envio postal.
	 * 
	 * DatosEnvioPostal
	 * 
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal getDatosEnvioPostal() {
		return this.datosEnvioPostal;
	}

	/**
	 * Sets the datos envio postal.
	 * 
	 * datosEnvioPostal DatosEnvioPostal
	 * 
	 * @param datosEnvioPostal
	 *            the new datos envio postal
	 */
	public void setDatosEnvioPostal(DatosEnvioPostal datosEnvioPostal) {
		this.datosEnvioPostal = datosEnvioPostal;
	}

	/**
	 * Gets the dokusi format.
	 * 
	 * String
	 * 
	 * @return the dokusi format
	 */
	public String getDokusiFormat() {
		return this.dokusiFormat;
	}

	/**
	 * Sets the dokusi format.
	 * 
	 * dokusiFormat String
	 * 
	 * @param dokusiFormat
	 *            the new dokusi format
	 */
	public void setDokusiFormat(String dokusiFormat) {
		this.dokusiFormat = dokusiFormat;
	}

	/**
	 * Gets the datos fichero.
	 * 
	 * byte[]
	 * 
	 * @return the datos fichero
	 */
	public byte[] getDatosFichero() {
		return this.datosFichero;
	}

	/**
	 * Sets the datos fichero.
	 * 
	 * datosFichero byte[]
	 * 
	 * @param datosFichero
	 *            the new datos fichero
	 */
	public void setDatosFichero(byte[] datosFichero) {
		if (datosFichero == null) {
			this.datosFichero = new byte[0];
		} else {
			this.datosFichero = Arrays
					.copyOf(datosFichero, datosFichero.length);
		}
	}

	/**
	 * Gets the idapetemp 065.
	 * 
	 * the idapetemp065
	 * 
	 * @return the idapetemp 065
	 */
	public Long getIdapetemp065() {
		return idapetemp065;
	}

	/**
	 * Sets the idapetemp 065.
	 * 
	 * idapetemp065 the idapetemp065 to set
	 * 
	 * @param idapetemp065
	 *            the new idapetemp 065
	 */
	public void setIdapetemp065(Long idapetemp065) {
		this.idapetemp065 = idapetemp065;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * String
	 * 
	 * @return the string
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idDocumento065: ").append(this.idDocumento065)
				.append(" ]");
		result.append(", [ idTramiteAperturas065: ")
				.append(this.tramiteAperturas).append(" ]");
		result.append(", [ origen065: ").append(this.origen065).append(" ]");
		result.append(", [ fechaDoc065: ").append(this.fechaDoc065)
				.append(" ]");
		result.append(", [ rutaPif065: ").append(this.rutaPif065).append(" ]");
		result.append(", [ nombreDoc065: ").append(this.nombreDoc065)
				.append(" ]");
		result.append(", [ oidDokusi065: ").append(this.oidDokusi065)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Checks if is migrado.
	 * 
	 * true, if is migrado
	 * 
	 * @return true, if is migrado
	 */
	public boolean isMigrado() {
		return migrado;
	}

	/**
	 * Sets the migrado.
	 * 
	 * migrado the new migrado
	 * 
	 * @param migrado
	 *            the new migrado
	 */
	public void setMigrado(boolean migrado) {
		this.migrado = migrado;
	}

	/**
	 * @param territorio
	 *            the territorio to set
	 */
	public void setTerritorio(String territorio) {
		this.territorio = territorio;
	}

	/**
	 * @return the territorio
	 */
	public String getTerritorio() {
		return territorio;
	}

}
